/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.ast;

import icyllis.annotations.Nullable;
import icyllis.flexmark.util.ast.Node;
import icyllis.flexmark.util.collection.iteration.ReversiblePeekingIterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

public class NodeIterator
implements ReversiblePeekingIterator<Node> {
    final Node firstNode;
    final Node lastNode;
    final boolean reversed;
    Node node;
    Node result;
    public static final ReversiblePeekingIterator<Node> EMPTY = new ReversiblePeekingIterator<Node>(){

        @Override
        public void remove() {
        }

        @Override
        public boolean isReversed() {
            return false;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Node next() {
            throw new NoSuchElementException();
        }

        @Override
        @Nullable
        public Node peek() {
            return null;
        }
    };

    public NodeIterator(Node firstNode) {
        this(firstNode, null, false);
    }

    public NodeIterator(Node firstNode, boolean reversed) {
        this(firstNode, null, reversed);
    }

    public NodeIterator(Node firstNode, Node lastNode) {
        this(firstNode, lastNode, false);
    }

    public NodeIterator(Node firstNode, Node lastNode, boolean reversed) {
        if (firstNode == null) {
            throw new NullPointerException();
        }
        this.firstNode = firstNode;
        this.lastNode = lastNode;
        this.reversed = reversed;
        this.node = reversed ? lastNode : firstNode;
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public boolean hasNext() {
        return this.node != null;
    }

    @Override
    public Node next() {
        this.result = null;
        if (this.node == null) {
            throw new NoSuchElementException();
        }
        this.result = this.node;
        Node node = this.node = this.reversed ? this.node.getPrevious() : this.node.getNext();
        if (this.node == null || this.result == (this.reversed ? this.firstNode : this.lastNode)) {
            this.node = null;
        }
        return this.result;
    }

    @Override
    @Nullable
    public Node peek() {
        if (this.node != null) {
            return this.node;
        }
        return null;
    }

    @Override
    public void remove() {
        if (this.result == null) {
            throw new IllegalStateException("Either next() was not called yet or the node was removed");
        }
        this.result.unlink();
        this.result = null;
    }

    @Override
    public void forEachRemaining(Consumer<? super Node> consumer) {
        if (consumer == null) {
            throw new NullPointerException();
        }
        while (this.hasNext()) {
            consumer.accept(this.next());
        }
    }
}

